package nemosofts.voxradio.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.MainActivity;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.activity.PodcastsByActivity;
import nemosofts.voxradio.activity.RadioByActivity;
import nemosofts.voxradio.adapter.Home.AdapterHomeCategories;
import nemosofts.voxradio.adapter.Home.AdapterHomeCountries;
import nemosofts.voxradio.adapter.Home.AdapterHomePodcasts;
import nemosofts.voxradio.adapter.Home.AdapterHomeTrending;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.fragment.Online.FragmentCategories;
import nemosofts.voxradio.fragment.Online.FragmentCountries;
import nemosofts.voxradio.fragment.Online.FragmentLatest;
import nemosofts.voxradio.interfaces.InterAdListener;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.recycler.RecyclerItemClickListener;

public class AdapterSearch extends RecyclerView.Adapter {

    Context context;
    Helper helper;
    List<ItemPost> arrayList;
    int clickPos = 0;

    static final int VIEW_PROG = 0;
    static final int VIEW_CATEGORIES = 1;
    static final int VIEW_COUNTRIES = 2;
    static final int VIEW_PODCASTS = 3;
    static final int VIEW_RADIO = 4;

    AdapterHomeTrending adapterHomeRadio;

    public AdapterSearch(Context context, List<ItemPost> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        helper = new Helper(context, interAdListener);
    }

    class CategoriesHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_cat;
        AdapterHomeCategories adapterHomeCategories;
        TextView tv_title;
        LinearLayout ll_home_view_all;

        CategoriesHolder(View view) {
            super(view);
            rv_cat = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            ll_home_view_all = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_cat.setLayoutManager(linearLayoutManager);
            rv_cat.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class CountriesHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_cou;
        AdapterHomeCountries adapterHomeCountries;
        TextView tv_title;
        LinearLayout ll_home_view_all;

        CountriesHolder(View view) {
            super(view);
            rv_cou = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            ll_home_view_all = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_cou.setLayoutManager(linearLayoutManager);
            rv_cou.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class PodcastsHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_pod;
        AdapterHomePodcasts adapterHomePodcasts;
        TextView tv_title;
        LinearLayout ll_home_view_all;

        PodcastsHolder(View view) {
            super(view);
            rv_pod = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            ll_home_view_all = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_pod.setLayoutManager(linearLayoutManager);
            rv_pod.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class RadiosHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_radio;
        TextView tv_title;
        LinearLayout ll_home_view_all;
        RadiosHolder(View view) {
            super(view);
            rv_radio = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            ll_home_view_all = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_radio.setLayoutManager(linearLayoutManager);
            rv_radio.setItemAnimator(new DefaultItemAnimator());
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        @SuppressLint("StaticFieldLeak")
        private static ProgressBar progressBar;

        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_CATEGORIES) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CategoriesHolder(itemView);
        } else if (viewType == VIEW_COUNTRIES) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CountriesHolder(itemView);
        } else if (viewType == VIEW_PODCASTS) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new PodcastsHolder(itemView);
        } else if (viewType == VIEW_RADIO) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new RadiosHolder(itemView);
        } else {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof CategoriesHolder) {

            ((CategoriesHolder) holder).tv_title.setText(arrayList.get(holder.getAdapterPosition()).getTitle());

            ((CategoriesHolder) holder).adapterHomeCategories = new AdapterHomeCategories(arrayList.get(holder.getAdapterPosition()).getArrayListCategories());
            ((CategoriesHolder) holder).rv_cat.setAdapter(((CategoriesHolder) holder).adapterHomeCategories);

            ((CategoriesHolder) holder).rv_cat.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.categories));
            }));

            ((CategoriesHolder) holder).ll_home_view_all.setOnClickListener(v -> {
                FragmentCategories f_albums = new FragmentCategories();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, f_albums, context.getString(R.string.categories));
                ft.addToBackStack(context.getString(R.string.categories));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.categories));
                ((MainActivity) context).bottomNavigationView(3);
            });
        }
        else if (holder instanceof CountriesHolder) {

            ((CountriesHolder) holder).tv_title.setText(arrayList.get(holder.getAdapterPosition()).getTitle());

            ((CountriesHolder) holder).adapterHomeCountries = new AdapterHomeCountries(arrayList.get(holder.getAdapterPosition()).getArrayListCountries());
            ((CountriesHolder) holder).rv_cou.setAdapter(((CountriesHolder) holder).adapterHomeCountries);

            ((CountriesHolder) holder).rv_cou.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.countries));
            }));

            ((CountriesHolder) holder).ll_home_view_all.setOnClickListener(v -> {
                FragmentCountries f_countries = new FragmentCountries();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, f_countries, context.getString(R.string.countries));
                ft.addToBackStack(context.getString(R.string.countries));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.countries));
                ((MainActivity) context).bottomNavigationView(5);
            });
        }
        else if (holder instanceof PodcastsHolder) {

            ((PodcastsHolder) holder).tv_title.setText(arrayList.get(holder.getAdapterPosition()).getTitle());

            ((PodcastsHolder) holder).adapterHomePodcasts = new AdapterHomePodcasts(arrayList.get(holder.getAdapterPosition()).getArrayListPodcasts());
            ((PodcastsHolder) holder).rv_pod.setAdapter(((PodcastsHolder) holder).adapterHomePodcasts);

            ((PodcastsHolder) holder).rv_pod.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.podcasts));
            }));

            ((PodcastsHolder) holder).ll_home_view_all.setOnClickListener(v -> {
                FragmentCountries f_podcasts = new FragmentCountries();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, f_podcasts, context.getString(R.string.podcasts));
                ft.addToBackStack(context.getString(R.string.podcasts));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.podcasts));
                ((MainActivity) context).bottomNavigationView(5);
            });
        }
        else if (holder instanceof RadiosHolder && (adapterHomeRadio == null)){
            ((RadiosHolder) holder).tv_title.setText(arrayList.get(holder.getAdapterPosition()).getTitle());

            adapterHomeRadio = new AdapterHomeTrending(context, arrayList.get(holder.getAdapterPosition()).getArrayListRadio(), false, position12 -> {
                if (helper.isNetworkAvailable()) {
                    Callback.isRadio = true;
                    String addedFrom = "home".concat(arrayList.get(holder.getAdapterPosition()).getTitle());
                    if (!Callback.addedFrom.equals(addedFrom)) {
                        Callback.arrayList_play.clear();
                        Callback.arrayList_play.addAll(arrayList.get(holder.getAdapterPosition()).getArrayListRadio());
                        Callback.addedFrom = addedFrom;
                        Callback.isNewAdded = true;
                    }
                    Callback.playPos = position12;
                    helper.showInterAd(position12, context.getString(R.string.radio));
                } else {
                    Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                }
            });
            ((RadiosHolder) holder).rv_radio.setAdapter(adapterHomeRadio);

            ((RadiosHolder) holder).ll_home_view_all.setOnClickListener(v -> {
                FragmentLatest f_latest = new FragmentLatest();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, f_latest, context.getString(R.string.latest));
                ft.addToBackStack(context.getString(R.string.latest));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.latest));
                ((MainActivity) context).bottomNavigationView(1);
            });
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public void hideHeader() {
        ProgressViewHolder.progressBar.setVisibility(View.GONE);
    }

    public boolean isHeader(int position) {
        return arrayList.get(position) == null;
    }

    @SuppressLint("NotifyDataSetChanged")
    public void onEqualizerChange() {
        try {
            if (adapterHomeRadio != null){
                adapterHomeRadio.notifyDataSetChanged();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemViewType(int position) {
        switch (arrayList.get(position).getType()) {
            case "radio":
                return VIEW_RADIO;
            case "countries":
                return VIEW_COUNTRIES;
            case "podcasts":
                return VIEW_PODCASTS;
            case "category":
                return VIEW_CATEGORIES;
            default:
                return VIEW_PROG;
        }
    }

    InterAdListener interAdListener = (position, type) -> {
        if (type.equals(context.getString(R.string.radio))) {
            Intent intent = new Intent(context, PlayerService.class);
            intent.setAction(PlayerService.ACTION_PLAY);
            context.startService(intent);
        } else if (type.equals(context.getString(R.string.categories))) {
            Intent intent = new Intent(context, RadioByActivity.class);
            intent.putExtra("type", context.getString(R.string.categories));
            intent.putExtra("id", arrayList.get(clickPos).getArrayListCategories().get(position).getId());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListCategories().get(position).getName());
            context.startActivity(intent);
        } else if (type.equals(context.getString(R.string.countries))) {
            Intent intent = new Intent(context, RadioByActivity.class);
            intent.putExtra("type", context.getString(R.string.countries));
            intent.putExtra("id", arrayList.get(clickPos).getArrayListCountries().get(position).getId());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListCountries().get(position).getName());
            context.startActivity(intent);
        } else if (type.equals(context.getString(R.string.podcasts))) {
            Intent intent = new Intent(context, PodcastsByActivity.class);
            intent.putExtra("id", arrayList.get(clickPos).getArrayListPodcasts().get(position).getId());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListPodcasts().get(position).getName());
            context.startActivity(intent);
        }
    };
}